#version 330

uniform mat4x4 ModelMatrix;
uniform mat4x4 ViewProjectionMatrix;

in vec2 vert_TexCoord;
in vec3 vert_Normal;
in vec3 vert_Position;

out vec2 TexCoord;
out vec3 Normal;

void main()
{
	TexCoord = vert_TexCoord;
	Normal = (ModelMatrix * vec4(vert_Normal, 0.0)).xyz;
	gl_Position = ViewProjectionMatrix * (ModelMatrix * vec4(vert_Position, 1.0));
}
